% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{alter_table_schema}
\alias{alter_table_schema}
\title{Move Tables from One Schema to Another}
\usage{
alter_table_schema(.con, from_table_names, new_schema)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{from_table_names}{Character vector of table names to move.}

\item{new_schema}{Target schema name (where the tables will be moved).}
}
\value{
Invisibly returns a character vector of fully-qualified table names moved.
Side effects: creates \code{new_schema} if needed and alters table schemas.
}
\description{
Moves one or more tables from an existing schema to a new (target) schema
using \verb{ALTER TABLE ... SET SCHEMA}. If the target schema does not exist,
it is created first.
}
\details{
\itemize{
\item Ensures \code{new_schema} exists (\verb{CREATE SCHEMA IF NOT EXISTS}).
\item For each table in \code{table_names}, runs:
\verb{ALTER TABLE old_schema.table SET SCHEMA new_schema}.
\item Table and schema identifiers are safely quoted with \code{glue::glue_sql()}.
}
}
\seealso{
Other db-manage: 
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
