% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_norm}
\alias{mo_norm}
\title{Moments of Order Statistics from the Normal Distribution (Simulated)}
\usage{
mo_norm(r, n, k = 1, mean = 0, sd = 1, rep = 1e+05, seed = 42)
}
\arguments{
\item{r}{rank of the desired order statistic (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{mean}{mean of the normal distribution (default is \code{0}).}

\item{sd}{standard deviation of the normal distribution (default is \code{1}).}

\item{rep}{number of simulations (default is \code{1e5}).}

\item{seed}{optional seed for random number generation to ensure reproducibility (default is \code{42}).}
}
\value{
The estimated \eqn{k}th moment of the \eqn{r}th order statistic from a normal distribution.
}
\description{
This function computes the moments of order statistics from the normal distribution
using simulation.
}
\details{
This function estimates the \eqn{k}th moment of the \eqn{r}th order statistic in a sample of size \eqn{n}
drawn from a normal distribution with the specified mean and standard deviation.
The estimation is done via Monte Carlo simulation using the formula:

\deqn{\text{E}[X^k] \approx \frac{1}{\mathrm{rep}} \sum_{i=1}^{\mathrm{rep}} X_i^k,}
where \eqn{X_i} are the simulated order statistics obtained from the normal distribution.

The function relies on the \code{ros()} function to generate order statistics.
}
\note{
The accuracy of the estimated moment depends on the number of simulations (\code{rep}).
The default value \code{rep = 1e5} provides a reasonable trade-off between speed and accuracy
for most practical cases. For higher order moments or when greater precision is required,
users are encouraged to increase \code{rep} (e.g. \code{1e6}).
}
\examples{
# Compute the first moment (mean) of the 3rd order statistic from a sample of size 10
mo_norm(r = 3, n = 10, k = 1, mean = 0, sd = 1)

# Compute the second moment of the 2nd order statistic with 1 million simulations
mo_norm(r = 2, n = 10, k = 2, rep = 1e6)

}
\seealso{
\code{\link{ros}}
}
