% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphLearner.R
\name{set_validate.GraphLearner}
\alias{set_validate.GraphLearner}
\title{Configure Validation for a GraphLearner}
\usage{
\method{set_validate}{GraphLearner}(
  learner,
  validate,
  ids = NULL,
  args_all = list(),
  args = list(),
  ...
)
}
\arguments{
\item{learner}{(\code{\link{GraphLearner}})\cr
The graph learner to configure.}

\item{validate}{(\code{numeric(1)}, \code{"predefined"}, \code{"test"}, or \code{NULL})\cr
How to set the \verb{$validate} field of the learner.
If set to \code{NULL} all validation is disabled, both on the graph learner level, but also for all pipeops.}

\item{ids}{(\code{NULL} or \code{character()})\cr
For which pipeops to enable validation.
This parameter is ignored when \code{validate} is set to \code{NULL}.
By default, validation is enabled for the final \code{PipeOp} in the \code{Graph}.}

\item{args_all}{(\code{list()})\cr
Rarely needed. A named list of parameter values that are passed to all subsequet \code{\link[mlr3:mlr_sugar]{set_validate()}} calls on the individual
\code{PipeOp}s.}

\item{args}{(named \code{list()})\cr
Rarely needed.
A named list of lists, specifying additional argments to be passed to \code{\link[mlr3:mlr_sugar]{set_validate()}} when calling it on the individual
\code{PipeOp}s.}

\item{...}{(any)\cr
Currently unused.}
}
\description{
Configure validation for a graph learner.

In a \code{\link{GraphLearner}}, validation can be configured on two levels:
\enumerate{
\item On the \code{\link{GraphLearner}} level, which specifies \strong{how} the validation set is constructed before entering the graph.
\item On the level of the individual \code{PipeOp}s (such as \code{PipeOpLearner}), which specifies
which pipeops actually make use of the validation data (set its \verb{$validate} field to \code{"predefined"}) or not (set it to \code{NULL}).
This can be specified via the argument \code{ids}.
}
}
\examples{
library(mlr3)

glrn = as_learner(po("pca") \%>>\% lrn("classif.debug"))
set_validate(glrn, 0.3)
glrn$validate
glrn$graph$pipeops$classif.debug$learner$validate

set_validate(glrn, NULL)
glrn$validate
glrn$graph$pipeops$classif.debug$learner$validate

set_validate(glrn, 0.2, ids = "classif.debug")
glrn$validate
glrn$graph$pipeops$classif.debug$learner$validate
}
