% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpMultiplicity.R
\name{mlr_pipeops_multiplicityimply}
\alias{mlr_pipeops_multiplicityimply}
\alias{PipeOpMultiplicityImply}
\title{Implicate a Multiplicity}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Implicate a \code{\link{Multiplicity}} by returning the input(s) converted to a \code{\link{Multiplicity}}.

This \code{\link{PipeOp}} has multiple input channels; all inputs are collected into a \code{\link{Multiplicity}}
and then are forwarded along a single edge, causing the following \code{\link{PipeOp}}s to be called
multiple times, once for each \code{\link{Multiplicity}} member.

Note that \code{\link{Multiplicity}} is currently an experimental features and the implementation or UI
may change.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpMultiplicityImply$new(innum = 0, id = "multiplicityimply", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{innum} :: \code{numeric(1)} | \code{character}\cr
Determines the number of input channels.
If \code{innum} is 0 (default), a vararg input channel is created that can take an arbitrary number
of inputs. If \code{innum} is a \code{character} vector, the number of input channels is the length of
\code{innum}.
\item \code{id} :: \code{character(1)}\cr
Identifier of the resulting object, default \code{"multiplicityimply"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise
be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpMultiplicityImply}} has multiple input channels depending on the \code{innum} construction
argument, named \code{"input1"}, \code{"input2"}, ... if \code{innum} is nonzero; if \code{innum} is 0, there is
only one \emph{vararg} input channel named \code{"..."}. All input channels take any input (\code{"*"}) both
during training and prediction.

\code{\link{PipeOpMultiplicityImply}} has one output channel named \code{"output"}, emitting a \code{\link{Multiplicity}}
of type any (\code{"[*]"}), i.e., returning the input(s) converted to a \code{\link{Multiplicity}} both during
training and prediction.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\code{\link{PipeOpMultiplicityImply}} has no Parameters.
}

\section{Internals}{

If \code{innum} is not \code{numeric}, e.g., a \code{character}, the output \code{\link{Multiplicity}} will be named based
on the input channel names
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
library("mlr3")
task1 = tsk("iris")
task2 = tsk("mtcars")
po = po("multiplicityimply")
po$train(list(task1, task2))
po$predict(list(task1, task2))
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEncodePL}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_decode}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encodeplquantiles}},
\code{\link{mlr_pipeops_encodepltree}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_pi_cvplus}},
\code{\link{mlr_pipeops_learner_quantiles}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nearmiss}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tomek}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Multiplicity PipeOps: 
\code{\link{Multiplicity}()},
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_replicate}}

Other Experimental Features: 
\code{\link{Multiplicity}()},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_replicate}}
}
\concept{Experimental Features}
\concept{Multiplicity PipeOps}
\concept{PipeOps}
