% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_ranger.R
\name{LearnerRanger}
\alias{LearnerRanger}
\title{R6 Class to construct a Ranger learner}
\description{
The \code{LearnerRanger} class is the interface to the \code{ranger} R package for use
with the \code{mlexperiments} package.
}
\details{
Optimization metric:
\itemize{
\item classification: classification error rate
\item regression: mean squared error
Can be used with
\item \link[mlexperiments:MLTuneParameters]{mlexperiments::MLTuneParameters}
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
\item \link[mlexperiments:MLNestedCV]{mlexperiments::MLNestedCV}
}
}
\examples{
# binary classification

library(mlbench)
data("PimaIndiansDiabetes2")
dataset <- PimaIndiansDiabetes2 |>
  data.table::as.data.table() |>
  na.omit()

seed <- 123
feature_cols <- colnames(dataset)[1:8]

param_list_ranger <- expand.grid(
  num.trees = seq(500, 1000, 500),
  mtry = seq(2, 6, 2),
  min.node.size = seq(1, 9, 4),
  max.depth = seq(1, 9, 4),
  sample.fraction = seq(0.5, 0.8, 0.3)
)

train_x <- model.matrix(
  ~ -1 + .,
  dataset[, .SD, .SDcols = feature_cols]
)
train_y <- as.integer(dataset[, get("diabetes")]) - 1L

fold_list <- splitTools::create_folds(
  y = train_y,
  k = 3,
  type = "stratified",
  seed = seed
)
ranger_cv <- mlexperiments::MLCrossValidation$new(
  learner = mllrnrs::LearnerRanger$new(),
  fold_list = fold_list,
  ncores = 2,
  seed = 123
)
ranger_cv$learner_args <- c(
  as.list(
    data.table::data.table(
      param_list_ranger[37, ],
      stringsAsFactors = FALSE
    ),
  ),
  list(classification = TRUE)
)
ranger_cv$performance_metric_args <- list(positive = "1", negative = "0")
ranger_cv$performance_metric <- mlexperiments::metric("AUC")

# set data
ranger_cv$set_data(
  x = train_x,
  y = train_y
)

ranger_cv$execute()


## ------------------------------------------------
## Method `LearnerRanger$new`
## ------------------------------------------------

LearnerRanger$new()

}
\seealso{
\code{\link[ranger:ranger]{ranger::ranger()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerRanger}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRanger-new}{\code{LearnerRanger$new()}}
\item \href{#method-LearnerRanger-clone}{\code{LearnerRanger$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRanger-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRanger-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerRanger} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRanger$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{LearnerRanger} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerRanger$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRanger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRanger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRanger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
