% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_predict.R, R/vlmc_predict_cpp.R
\name{predict.vlmc}
\alias{predict.vlmc}
\alias{predict.vlmc_cpp}
\title{Next state prediction in a discrete time series for a VLMC}
\usage{
\method{predict}{vlmc}(object, newdata, type = c("raw", "probs"), final_pred = TRUE, ...)

\method{predict}{vlmc_cpp}(object, newdata, type = c("raw", "probs"), final_pred = TRUE, ...)
}
\arguments{
\item{object}{a fitted vlmc object.}

\item{newdata}{a time series adapted to the vlmc object.}

\item{type}{character indicating the type of prediction required. The default
\code{"raw"} returns actual predictions in the form of a new time series. The
alternative \code{"probs"} returns a matrix of prediction probabilities (see
details).}

\item{final_pred}{if \code{TRUE} (default value), the predictions include a final
prediction step, made by computing the context of the full time series.
When \code{FALSE} this final prediction is not included.}

\item{...}{additional arguments.}
}
\value{
A vector of predictions if \code{type="raw"} or a matrix of state
probabilities if \code{type="probs"}.
}
\description{
This function computes one step ahead predictions for a discrete time series
based on a VLMC.
}
\details{
Given a time series \code{X}, at time step \code{t}, a context is computed using
observations from \code{X[1]} to \code{X[t-1]} (see the dedicated section). The
prediction is then the most probable state for \code{X[t]} given this contexts.
Ties are broken according to the natural order in the state space, favouring
"small" values. The time series of predictions is returned by the function
when \code{type="raw"} (default case).

When \code{type="probs"}, each \code{X[t]} is associated to the conditional
probabilities of the next state given the context. Those probabilities are
returned as a matrix of probabilities with column names given by the state
names.
}
\section{Extended contexts}{


As explained in details in \code{\link[=loglikelihood.vlmc]{loglikelihood.vlmc()}} documentation and in the
dedicated \code{vignette("likelihood", package = "mixvlmc")}, the first initial
values of a time series do not in general have a proper context for a VLMC
with a non zero order. In order to predict something meaningful for those
values, we rely on the notion of extended context defined in the documents
mentioned above. This follows the same logic as using
\code{\link[=loglikelihood.vlmc]{loglikelihood.vlmc()}} with the parameter \code{initial="extended"}. All vlmc
functions that need to manipulate initial values with no proper context use
the same approach.
}

\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts, min_size = 5)
predict(model, dts[1:5])
predict(model, dts[1:5], "probs")
## C++ backend
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts, min_size = 5, backend = "C++")
predict(model, dts[1:5])
predict(model, dts[1:5], "probs")
}
