% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateData.R
\name{CorrStructure}
\alias{CorrStructure}
\alias{autocor}
\alias{blockcor}
\title{Construct a correlation matrix}
\usage{
autocor(p, rho)

blockcor(blockind, rho)
}
\arguments{
\item{p}{Specified matrix dimension.}

\item{rho}{Correlation value(s), must be between -0.99 and 0.99. Should be a scalar for \code{autocor}, and either a scalar or a vector of the same length as the maximal \code{blockind} K for \code{blockcor}.}

\item{blockind}{Block index 1,\dots, K for a positive integer K specifying which variable belongs to which block, the matrix dimension is equal to \code{length(blockind)}.}
}
\description{
Functions to create autocorrelation matrix (p by p) with parameter rho and block correlation matrix (p by p) using group index (of length p) and (possibly) different parameter rho for each group.
}
\examples{
# For p = 8,
# auto correlation matrix
autocor(8, 0.8)
# block correlation matrix: two blocks with the same correlation within each block
blockcor(c(rep(1,3), rep(2,5)), 0.8)
# block correlation matrix: two blocks with different correlation within each block
blockcor(c(rep(1,3), rep(2,5)), c(0.8, 0.3))

}
