% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBO_opt.R
\name{CBO}
\alias{CBO}
\title{Coot Bird Optimization}
\usage{
CBO(N, Max_iter, lb, ub, dim, fobj)
}
\arguments{
\item{N}{An integer indicate population size.}

\item{Max_iter}{An integer indicate maximum number of iterations.}

\item{lb}{A numeric vector that show lower bounds of the search space. One value per dimension.}

\item{ub}{A numeric vector that show upper bounds of the search space. One value per dimension.}

\item{dim}{An integer show the number of dimension (parameters) of the problem to optimize. It indicate the number of parameters to be optimized.}

\item{fobj}{An objective function used to be minimized. It is return single numeric value that show evaluation matrix result in every iteration.
It used to calculate the best fitness in every iteration.}
}
\value{
A list containing:
\describe{
  \item{best_fitness}{The best (minimum) fitness value found.}
  \item{best_position}{The parameter vector (position) corresponding to the best fitness.}
  \item{jml_iter}{The number of iterations executed.}
  \item{param}{Matrix of best parameters found across every iterations (dim × iter).}
  \item{param_list}{Vector of best fitness values at each iteration.}
}
}
\description{
An algorithm built by Naruei & Keynia (2021) that mimics the regular-irregular movement behaviour of
Coot birds. Its population divided by two groups as leaders to guide the process and coots to follow leaders and randomly explore search space.
This movement use to  optimized real-valued objective function in continuous search space.
}
\details{
This algorithms used movement such as: random movement, chain movement, adjusting the position based on
the group leaders, and leader movement to emphasize the exploration and exploitation phase to get the best fitness.

The algorithm performs until maximum iteration reached or convergence condition when the difference
in objective values for ten consecutive times is less than 10^-5.
}
\note{
The input vectors 'lb' and 'ub' must have the same length as the number of dimensions 'dim'.

This optimization function used inside svrHybrid function.
}
\examples{
{
sphere_fn <- function(x) sum(x^2) # simple function for objective function

# CBO optimization
set.seed(123)
result <- CBO(N = 20, Max_iter = 50, lb = c(-5,-5,-5), ub = c(5,5,5), dim = 3, fobj = sphere_fn)

# View best fitness and position found
result$best_fitness
result$best_position
}

}
\references{
Naruei, I., & Keynia, F. (2021). A New Optimization Method Based on COOT Bird Natural Life Model.
Expert Systems with Applications, 183. https://doi.org/10.1016/j.eswa.2021.115352
}
