% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merList.R
\name{VarCorr.merModList}
\alias{VarCorr.merModList}
\title{Extract the variances and correlations for random effects from a merMod list}
\usage{
\method{VarCorr}{merModList}(x, sigma = 1, rdig = 3L, ...)
}
\arguments{
\item{x}{a \code{\link{merModList}} list fitted models with random effects}

\item{sigma}{an optional numeric value used as a multiplier for the
    standard deviations.}

\item{rdig}{the number of digits to round to, integer}

\item{...}{Ignored for the \code{as.data.frame} method; passed to
    other \code{\link{print}()} methods for the \code{print()} method.}
}
\value{
a list with two elements "stddev" and "correlation" for the standard
deviations and correlations averaged across models in the list
}
\description{
Extract the variances and correlations for random effects from a merMod list
}
\examples{
sim_list <- replicate(n = 10,
        expr = sleepstudy[sample(row.names(sleepstudy), 180),],
        simplify=FALSE)
fml <- "Reaction ~ Days + (Days | Subject)"
mod <- lmerModList(fml, data = sim_list)
VarCorr(mod)
}
