% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup_icd_codes.R
\name{lookup_icd_codes}
\alias{lookup_icd_codes}
\title{Lookup ICD Codes}
\usage{
lookup_icd_codes(
  x,
  regex = FALSE,
  full.codes = TRUE,
  compact.codes = TRUE,
  ...
)
}
\arguments{
\item{x}{Character vector of ICD codes (full or compact form).}

\item{regex}{Logical scalar. If \code{TRUE}, treat \code{x} as regular
expressions; if \code{FALSE}, use exact matching.}

\item{full.codes}{Logical scalar. If \code{TRUE} (default), match codes that
include the decimal point where applicable.}

\item{compact.codes}{Logical scalar. If \code{TRUE} (default), match codes without
the decimal point.}

\item{...}{Passed to \code{\link[base:grep]{base::grep()}} when \code{regex = TRUE}}
}
\value{
A \code{data.frame} with one or more rows per input, including columns
\itemize{
\item \code{match_type}: did the input match a full or compact code
\item \code{icdv}: icd version (9 or 10)
\item \code{dx}: diagnostic code (1) or procedure code (0)
\item \code{full_code}: the full code string
\item \code{code}: the compact codes string
\item \code{src}: the source - CMS, CDC, or WHO.
\item year ranges (\verb{known_*}, \verb{assignable_*}).
}
}
\description{
Functions for working with ICD codes.

ICD-10 code "C00" is a header code because the four-character codes
C00.0, C00.1, C00.2, C00.3, C00.4, C00.5, C00.6, C00.7, C00.8, and C00.9
exist. Those four-character codes are assignable (as of 2025) because no
five-character descendants (e.g., C00.40) exist.

When the source is the World Health Organization (WHO) or CDC Mortality,
years refer to calendar years. CDC/CMS sources use the U.S. federal fiscal
year, which starts on October 1 (e.g., fiscal year 2024 runs 2023-10-01 to
2024-09-30).
}
\details{
ICD codes should be character vectors. These tools work with either
"full codes" (decimal point present when appropriate) or "compact codes"
(decimal point omitted).

Similarly for ICD-9-CM: "055" is a header for measles; 055.0, 055.1,
055.2, 055.8, and 055.9 are assignable. Codes 055.3–055.6 do not exist.
Code 055.7 is a header because 055.71 and 055.72 exist.

Some codes change status across years. For example, ICD-9-CM 516.3 was
assignable in fiscal years 2006–2011, then became a header in 2012–2015.
}
\seealso{
\itemize{
\item \code{\link[=get_icd_codes]{get_icd_codes()}} to retrieve the internal lookup table of ICD codes.
\item \code{\link[=is_icd]{is_icd()}} to test if a string is a known ICD code.
\item \code{\link[=icd_compact_to_full]{icd_compact_to_full()}} converts a string from a compact format to the
full format based on ICD version and type (diagnostic or procedure).
}

Other ICD tools: 
\code{\link{icd_compact_to_full}()},
\code{\link{is_icd}()}
}
\concept{ICD tools}
