% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_analysis.R
\name{mcmodule_converg}
\alias{mcmodule_converg}
\title{Analyse Monte Carlo Simulation Convergence}
\usage{
mcmodule_converg(
  mcmodule,
  from_quantile = 0.95,
  to_quantile = 1,
  conv_threshold = NULL,
  print_summary = TRUE,
  progress = FALSE
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing simulation results.}

\item{from_quantile}{(numeric). Lower bound quantile for analysis. Default: 0.95.}

\item{to_quantile}{(numeric). Upper bound quantile for analysis. Default: 1.}

\item{conv_threshold}{(numeric, optional). Custom convergence threshold for
standardised differences. Default: NULL.}

\item{print_summary}{(logical). If TRUE, print convergence analysis summary.
Default: TRUE.}

\item{progress}{(logical). If TRUE, print progress information. Default: FALSE.}
}
\value{
A data frame with convergence statistics. Each row represents one node.
Key columns:
\itemize{
\item expression: Expression identifier.
\item variate: Variate (data row) identifier.
\item node: Node name.
\item max_dif_scaled: Maximum standardised difference.
\item max_dif: Maximum raw difference.
\item conv_threshold: Convergence at custom threshold, if provided.
\item conv_01, conv_025, conv_05: Convergence at 1\%, 2.5\%, 5\% thresholds.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Analyses convergence in Monte Carlo simulations by computing standardised
and raw differences between consecutive iterations to evaluate stability and
convergence of statistical measures.
}
\details{
The function performs the following:
\itemize{
\item Calculates convergence statistics for specified quantile range
\item Generates diagnostic plots for standardized and raw differences
\item Provides detailed convergence summary including:
\itemize{
\item Total nodes analyzed
\item Number and percentage of nodes converged at different thresholds
\item Maximum/minimum deviations
\item List of non-converged nodes (if any)
}
}
}
\examples{
\dontrun{
results <- mcmodule_converg(mc_results)
results <- mcmodule_converg(mc_results, from_quantile = 0.90, conv_threshold = 0.01)
}

}
