% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_summary.R
\name{mc_summary}
\alias{mc_summary}
\title{Summarise Monte Carlo Node Values}
\usage{
mc_summary(
  mcmodule = NULL,
  mc_name = NULL,
  keys_names = NULL,
  data = NULL,
  mcnode = NULL,
  sep_keys = TRUE,
  digits = NULL
)
}
\arguments{
\item{mcmodule}{(mcmodule object, optional). Module containing the node.
Default: NULL.}

\item{mc_name}{(character, optional). Name of the mcnode in the module.}

\item{keys_names}{(character vector, optional). Column names for grouping.
Default: NULL.}

\item{data}{(data frame, optional). Input data frame. Default: NULL.}

\item{mcnode}{(mcnode object, optional). mcnode to summarise directly. Default: NULL.}

\item{sep_keys}{(logical). If TRUE, keep keys in separate columns; if FALSE,
combine into single column. Default: TRUE.}

\item{digits}{(integer, optional). Number of significant digits for rounding.
Default: NULL.}
}
\value{
A data frame with summary statistics for each mcnode variate.
Columns include:
\itemize{
\item mc_name: Node name.
\item Key columns (if sep_keys = TRUE) or single keys column (if FALSE).
\item mean: Average value.
\item sd: Standard deviation.
\item Quantile columns (2.5\%, 25\%, 50\%, 75\%, 97.5\%).
}
}
\description{
Computes summary statistics for an mcnode object, including mean,
standard deviation, and quantiles. Can be called with an mcmodule and
node name, or directly with an mcnode and data frame.
}
\details{
This function can be called in two ways:
\enumerate{
\item By providing an mcmodule and mc_name
\item By providing data and mcnode directly
}
}
\examples{
# Use with mcmodule
summary_basic <- mc_summary(imports_mcmodule, "w_prev")

# Using custom keys and rounding
summary_custom <- mc_summary(imports_mcmodule, "w_prev",
  keys_names = c("origin"),
  digits = 3
)

# Use with data and mcnode
w_prev <- imports_mcmodule$node_list$w_prev$mcnode
summary_direct <- mc_summary(
  data = imports_data,
  mcnode = w_prev,
  sep_keys = FALSE
)
}
