% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_network.R
\name{mc_network}
\alias{mc_network}
\title{Create Interactive Network Visualisation}
\usage{
mc_network(
  mcmodule,
  variate = 1,
  color_pal = NULL,
  color_by = NULL,
  legend = FALSE,
  inputs = FALSE
)
}
\arguments{
\item{mcmodule}{(mcmodule object). Module containing network to visualise.}

\item{variate}{(integer). Which variate to visualise. Default: 1.}

\item{color_pal}{(character vector, optional). Custom colour palette for nodes.
Default: NULL.}

\item{color_by}{(character, optional). Column name to determine node colours.
Default: NULL.}

\item{legend}{(logical). If TRUE, show colours legend. Default: FALSE.}

\item{inputs}{(logical). If TRUE, show non-node inputs. Default: FALSE.}
}
\value{
An interactive visNetwork object with highlighting of connected nodes,
node selection and filtering by module, directional arrows, hierarchical
layout, and draggable nodes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Generates an interactive network visualisation using visNetwork library.
The visualisation includes interactive features for exploring model structure
and relationships.
}
\examples{
\donttest{
network <- mc_network(mcmodule=imports_mcmodule)
}
}
