% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mcnodes.R
\name{create_mcnodes}
\alias{create_mcnodes}
\title{Create mcnodes from Data and Configuration Table}
\usage{
create_mcnodes(data, mctable = set_mctable(), envir = parent.frame())
}
\arguments{
\item{data}{(data frame). Input data containing variables for mcnode creation.}

\item{mctable}{(data frame). Configuration table with columns:
mcnode, mc_func, transformation, from_variable.}

\item{envir}{(environment, optional). Environment where nodes are created.
Default: parent.frame().}
}
\value{
NULL (invisibly). mcnodes created in \code{envir}.
}
\description{
Creates mcnodes based on mctable specifications and input data.
Applies transformations and generates mcnodes in the calling environment.
}
\examples{
create_mcnodes(
  data = imports_data,
  mctable = imports_mctable
)

}
