% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{pr_invwishart}
\alias{pr_invwishart}
\title{Create an object representing an inverse Wishart prior,
possibly with modelled scale matrix}
\usage{
pr_invwishart(df = NULL, scale = NULL)
}
\arguments{
\item{df}{Degrees of freedom parameter. This should be a scalar numeric value.
Default value is the dimension plus one.}

\item{scale}{Either a (known) scale matrix, or
\code{scale="modeled"} or \code{scale="modelled"}, which puts default
chi-squared priors on the diagonal elements of the inverse Wishart scale matrix.
For more control on these chi-squared priors a list can be passed with some of the
following components:
\describe{
  \item{df}{degrees of freedom (scalar or vector) of the chi-squared distribution(s)}
  \item{scale}{scale parameter(s) of the chi-squared distribution(s)}
  \item{common}{whether the modelled scale parameter of the inverse chi-squared
    distribution is (a scalar parameter) common to all \code{n} diagonal elements.}
}}
}
\value{
An environment representing the specified prior, for internal use.
}
\description{
Create an object representing an inverse Wishart prior,
possibly with modelled scale matrix
}
\references{
A. Huang and M.P. Wand (2013).
   Simple marginally noninformative prior
   distributions for covariance matrices.
   Bayesian Analysis 8, 439-452.
}
