% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_gamma.R
\name{f_gamma}
\alias{f_gamma}
\title{Specify a Gamma sampling distribution}
\usage{
f_gamma(
  link = "log",
  shape.vec = ~1,
  shape.prior = pr_gamma(0.1, 0.1),
  control = set_MH(type = "RWLN", scale = 0.2, adaptive = TRUE)
)
}
\arguments{
\item{link}{the name of a link function. Currently the only allowed link function
for the gamma distribution is \code{"log"}.}

\item{shape.vec}{optional formula specification of unequal shape parameter.}

\item{shape.prior}{prior for gamma shape parameter. Supported prior distributions:
\code{\link{pr_fixed}} with a default value of 1, \code{\link{pr_exp}} and
\code{\link{pr_gamma}}. The current default is \code{pr_gamma(shape=0.1, rate=0.1)}.}

\item{control}{options for the Metropolis-Hastings algorithm employed
in case the shape parameter is to be inferred. Function \code{\link{set_MH}}
can be used to change the default options. The two choices of proposal
distribution type supported are "RWLN" for a random walk proposal on the
log-shape scale, and "gamma" for an approximating gamma proposal, found using
an iterative algorithm. In the latter case, a Metropolis-Hastings accept-reject
step is currently omitted, so the sampling algorithm is an approximate one,
though often quite accurate and efficient.}
}
\value{
A family object.
}
\description{
This function can be used in the \code{family} argument of \code{\link{create_sampler}}
or \code{\link{generate_data}} to specify a Gamma sampling distribution.
}
\references{
J.W. Miller (2019).
   Fast and Accurate Approximation of the Full Conditional for Gamma Shape Parameters.
   Journal of Computational and Graphical Statistics 28(2), 476-480.
}
