% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hypcube_lhs}
\alias{hypcube_lhs}
\title{Latin Hypercube Sampling}
\usage{
hypcube_lhs(n, d, lbound = NA_real_, ubound = NA_real_)
}
\arguments{
\item{n}{Integer. The number of samples points of the hypercube.}

\item{d}{Integer. The the dimension of the hypercube.}

\item{lbound}{Numeric vector of length \code{d} specifying the
lower bounds for each dimension of the d-dimensional hypercube.}

\item{ubound}{Numeric vector of length \code{d} specifying the
ubound bounds for each dimension of the d-dimensional hypercube.}
}
\value{
A \code{n x d} matrix containing the LHS design. Each
element is scaled to the range defined by \code{lbound} and
\code{ubound}.
}
\description{
Generates a Latin Hypercube Sampling (LHS) design matrix over the hypercube.
}
\examples{
x = hypcube_lhs(100, 2)
plot(x, xlim = c(0,1), ylim = c(0,1))
rug(x[,1]); rug(x[,2], side = 2)
x = hypcube_lhs(100, 2, lbound = c(-5,1), ubound = c(10,3))
plot(x, xlim = c(-5,10), ylim = c(1,3))
rug(x[,1]); rug(x[,2], side = 2)
}
\references{
McKay, M.D., Beckman, R.J., Conover, W.J. (1979) A comparison of
three methods for selecting values of input variables in the
analysis of output from a computer code. Technometrics. 21(2),
239–-245 (reprinted in 2000: Technometrics 42(1), 55–61).

Owen, A. B. (1992b) A central limit theorem for Latin hypercube
sampling. JRSS Series B 54, 541-551.

Stein, M. (1987) Large sample properties of simulations using
Latin hypercube sampling. Technometrics 29, 143-151.
}
