% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I_h.R
\name{I_h}
\alias{I_h}
\title{Global insolation on Mars horizontal surface over time period}
\usage{
I_h(
  Ls,
  phi,
  longitude,
  tau,
  Ts_start,
  Ts_end,
  al = albedo(latitude = phi, longitude = longitude, tau = tau)
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{Ts_start}{Start of integration period [h]}

\item{Ts_end}{End of integration period [h]}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}
}
\value{
Global insolation over specified time period [Wh/m²]
}
\description{
Calculates the total solar energy received on a horizontal surface between specified start
and end times. Obtained by integrating global irradiance over the time period.
}
