% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io_functions.R
\name{save_transition_matrix}
\alias{save_transition_matrix}
\title{Save Transition Probability Matrix}
\usage{
save_transition_matrix(
  transition_df,
  file_path,
  nutrient,
  analysis_type = "combined",
  metadata = NULL
)
}
\arguments{
\item{transition_df}{Data frame. Transition probability matrix}

\item{file_path}{Character. Output file path}

\item{nutrient}{Character. Nutrient type}

\item{analysis_type}{Character. Type of analysis}

\item{metadata}{List. Additional metadata to include}
}
\value{
Character. Path to saved file
}
\description{
Save transition probability matrix to CSV with metadata
}
\examples{
\donttest{
# Create example analysis results first
results <- run_builtin_analysis(scale = "county", year = 2016, include_wwtp = TRUE)

# Save transition probabilities (only if integrated results exist)
if ("integrated" \%in\% names(results) && "nitrogen" \%in\% names(results$integrated)) {
  centroids <- add_centroid_coordinates(results$integrated$nitrogen)
  transitions <- calculate_transition_probabilities(centroids, "combined_N_class")
  save_transition_matrix(transitions,
                        file.path(tempdir(), "transitions_nitrogen.csv"),
                        "nitrogen")
}
}
}
