% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agricultural_functions.R
\name{agri_classify_complete_custom}
\alias{agri_classify_complete_custom}
\title{Complete Agricultural Classification Pipeline with Custom Efficiency Factors}
\usage{
agri_classify_complete_custom(
  nugis_data,
  scale,
  cropland_threshold = NULL,
  county_data = NULL,
  n_efficiency = 0.5,
  p_efficiency = 1
)
}
\arguments{
\item{nugis_data}{Data frame. Raw NuGIS data}

\item{scale}{Character. Spatial scale: "county", "huc8", or "huc2"}

\item{cropland_threshold}{Numeric. Optional custom threshold}

\item{county_data}{Data frame. County data for threshold calculation (if needed)}

\item{n_efficiency}{Numeric. Nitrogen efficiency factor (default: 0.5)}

\item{p_efficiency}{Numeric. Phosphorus efficiency factor (default: 1.0)}
}
\value{
Data frame with complete agricultural classifications for both nutrients
}
\description{
Run complete agricultural nutrient classification analysis for both N and P with
user-specified efficiency factors for sensitivity analysis.
}
\examples{
\donttest{
# Load county data
nugis_data <- load_builtin_nugis("county", 2016)

# Standard analysis
results_standard <- agri_classify_complete_custom(
  nugis_data, "county"
)

# Sensitivity analysis with varied nitrogen efficiency
results_high_n <- agri_classify_complete_custom(
  nugis_data, "county",
  n_efficiency = 0.7
)

# Analysis with both custom efficiencies
results_custom <- agri_classify_complete_custom(
  nugis_data, "county",
  n_efficiency = 0.6,
  p_efficiency = 0.9
)
}
}
