% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{has_categories}
\alias{has_categories}
\title{Test if an object has categorical variables.}
\usage{
has_categories(...)
}
\arguments{
\item{...}{Object that can be either a dataset or a data dictionary.}
}
\value{
A logical.
}
\description{
Test if the object has categorical variables, typically a data frame or
categorical entries in the data dictionary. This function mainly helps
validate input within other functions of the package but could be used to
check if a dataset or a data dictionary has categorical variables.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{

library(dplyr)

###### Example 1: use madshapR_examples provided by the package
dataset_with_cat <- madshapR_examples$`dataset_example` \%>\%
  mutate(prg_ever_cat = as_category(prg_ever))
  
has_categories(madshapR_examples$`dataset_example`)
has_categories(dataset_with_cat)
has_categories(madshapR_examples$`data_dictionary_example`)

###### Example 2: any data frame can be a dataset
has_categories(iris)
has_categories(mtcars)

}

}
