% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_to_logvar.R
\name{var_to_logvar}
\alias{var_to_logvar}
\title{Transform the between-subject variance in the positive scale to the
logvariance in the logarithmic scale}
\usage{
var_to_logvar(gen, emiss_mu, var_emiss, byrow = TRUE)
}
\arguments{
\item{gen}{List containing the following elements denoting the general model
properties:
\itemize{
\item{\code{m}: numeric vector with length 1 denoting the number
of hidden states}
\item{\code{n_dep}: numeric vector with length 1 denoting the
number of dependent variables}}}

\item{emiss_mu}{A list containing \code{n_dep} matrices, i.e., one list for
  each dependent variable \code{k}. Each matrix contains the group-level
  means of the lognormal emission distributions in each of the
  states in the natural (positive real numbers) scale. Hence, each
  matrix consists of either 1 row (when not including covariates in the
  model) and \code{m} columns (see \code{emiss_mu0} in
  \code{\link{prior_emiss_count}}), or \code{m} rows and 1 column
  (when not including covariates in the model; see \code{emiss_distr} in
  \code{\link{sim_mHMM}}), denoting the mean of state
  \emph{i} (column or row \emph{i}) of the lognormal distribution used as
  prior for the Poisson emissions. By default it is assumed that the
  matrices contain 1 row and \code{m} columns, as specified for
  \code{emiss_mu0} in \code{\link{prior_emiss_count}} (see argument
  \code{byrow}). If \code{emiss_mu} were to be specified using \code{m} rows
  and 1 column as for \code{emiss_distr} in \code{\link{sim_mHMM}}, then set
  the argument \code{byrow = FALSE}.

  Note: in every case the means should be specified in the natural
  (real positive) scale.}

\item{var_emiss}{A list containing \code{n_dep} elements corresponding to
each of the dependent variables \code{k}, where each element \code{k} is a
vector with length \code{m} denoting the amount of variance between the
subject (emission distribution) means in the natural (positive real
numbers) scale. It follows a similar specification as \code{emiss_V} in
\code{\link{prior_emiss_count}}.}

\item{byrow}{A logical scalar indicating whether the emission means are
specified in the first row (\code{byrow = TRUE}) or the first column
(\code{byrow = FALSE}) of the \code{n_dep} matrices listed in
\code{emiss_mu}. Use \code{byrow = TRUE} if \code{emiss_mu} is entered
as \code{emiss_mu0} in \code{\link{prior_emiss_count}}, and
\code{byrow = FALSE} if \code{emiss_mu} is entered as \code{emiss_distr}
in \code{\link{sim_mHMM}}. By default, \code{byrow = TRUE}.}
}
\value{
\code{var_to_logvar} Returns a list of \code{n_dep} numeric vectors
  of \code{m} elements denoting the state \code{i}-specific logvariance
  (between-subject variance in the logarithmic scale) for the
  \code{k}-dependent variable used as dispersion parameter in the lognormal
  prior for the Poisson emission distribution.
}
\description{
\code{var_to_logvar} returns the desired between-subject logvariance in the
  logarithmic scale corresponding to the between-subject variance in the
  (real) positive scale specified as input. The logvariance is used as the
  dispersion parameter in the lognormal distribution adopted as prior for
  the subject-specific Poisson means in the implementation of \code{mHMM}
  and \code{\link{sim_mHMM}} of \code{\link{mHMMbayes}} for count
  distributed data. It takes as inputs the group-level Poisson means
  \code{emiss_mu} and the desired between-subject variance \code{var_emiss},
  both in the (real) positive scale.
}
\examples{
###### Example on package data
\donttest{

## Example: specifying count priors manually using both positive and log scale:

# Define general parameters:
m       <- 3        # Number of hidden states
n_dep   <- 2        # Number of dependent variables

# Specify priors manually on the positive scale for emuss_mu0 and emiss_V:
manual_prior_emiss_1 <- prior_emiss_count(
  gen = list(m = m, n_dep = n_dep),
  emiss_mu0 = list(matrix(c(30, 70, 170), nrow = 1),
                   matrix(c(7, 8, 18), nrow = 1)),
  emiss_K0 = list(1, 1),
  emiss_V =  list(c(16,25,32),
                  rep(4, m)),
  emiss_nu = list(0.1, 0.1),
  log_scale = FALSE)

# Define logmu and logvar:
logmu <-  list(matrix(log(c(30, 70, 170)), nrow = 1),
               matrix(log(c(7, 8, 18)), nrow = 1))

logvar <- var_to_logvar(gen = list(m = m, n_dep = n_dep),
                        emiss_mu = list(matrix(c(30, 70, 170), nrow = 1),
                                        matrix(c(7, 8, 18), nrow = 1)),
                        var_emiss = list(c(16,25,32),
                                         rep(4, m)),
                        byrow = TRUE)

# Specify priors manually on the log scale for emiss_mu0 and emiss_V:
manual_prior_emiss_2 <- prior_emiss_count(
  gen = list(m = m, n_dep = n_dep),
  emiss_mu0 = logmu,
  emiss_K0 = list(1, 1),
  emiss_V =  logvar,
  emiss_nu = list(0.1, 0.1),
  log_scale = TRUE)

# Check whether they are identical:
identical(manual_prior_emiss_1, manual_prior_emiss_2)

}

}
\seealso{
\code{\link{mHMM}} for fitting the multilevel hidden Markov model,
  and \code{\link{sim_mHMM}} for simulating data from a multilevel hidden
  Markov model.
}
