% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignTwoMultinom}
\alias{getDesignTwoMultinom}
\title{Power and Sample Size for Difference in Two-Sample Multinomial
Responses}
\usage{
getDesignTwoMultinom(
  beta = NA_real_,
  n = NA_real_,
  ncats = NA_integer_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ncats}{The number of categories of the multinomial response.}

\item{pi1}{The prevalence of each category for the treatment group.
Only need to specify the valued for the first \code{ncats-1} categories.}

\item{pi2}{The prevalence of each category for the control group.
Only need to specify the valued for the first \code{ncats-1} categories.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designTwoMultinom} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The maximum number of subjects.
\item \code{ncats}: The number of categories of the multinomial response.
\item \code{pi1}: The prevalence of each category for the treatment group.
\item \code{pi2}: The prevalence of each category for the control group.
\item \code{effectsize}: The effect size for the chi-square test.
\item \code{allocationRatioPlanned}: Allocation ratio for the active treatment
versus control.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for difference in two-sample multinomial responses.
}
\details{
A two-arm multinomial response design is used to test whether the
prevalence of each category differs between two treatment arms.
Let \eqn{\pi_{gi}} denote the prevalence of category \eqn{i}
in group \eqn{g}, where \eqn{g=1} for the treatment group and
\eqn{g=2} for the control group.
The chi-square test statistic is given by
\deqn{X^2 = \sum_{g=1}^{2} \sum_{i=1}^{C}
\frac{(n_{gi} - n_{g+} n_{+i}/n)^2}{n_{g+} n_{+i}/n}}
where \eqn{n_{gi}} is the number of subjects in category \eqn{i}
for group \eqn{g}, \eqn{n_{g+}} is the total number of subjects
in group \eqn{g}, and \eqn{n_{+i}} is the total number of subjects
in category \eqn{i} across both groups, and
\eqn{n} is the total sample size.
\itemize{
\item Under the null hypothesis, \eqn{X^2} follows a chi-square distribution
with \eqn{C-1} degrees of freedom.
\item Under the alternative hypothesis, \eqn{X^2} follows a non-central
chi-square distribution with non-centrality parameter
\deqn{\lambda = n r (1-r) \sum_{i=1}^{C} \frac{(\pi_{1i} - \pi_{2i})^2}
  {r \pi_{1i} + (1-r)\pi_{2i}}}
where \eqn{r} is the randomization probability for the active treatment.
}

The sample size is chosen such that the power to reject the null
hypothesis is at least \eqn{1-\beta} for a given
significance level \eqn{\alpha}.
}
\examples{

(design1 <- getDesignTwoMultinom(
  beta = 0.1, ncats = 3, pi1 = c(0.3, 0.35),
  pi2 = c(0.2, 0.3), alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
