% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list2df_linter.R
\name{list2df_linter}
\alias{list2df_linter}
\title{Recommend direct usage of \code{data.frame()} to create a data.frame from a list}
\usage{
list2df_linter()
}
\description{
\code{\link[base:list2DF]{base::list2DF()}} is the preferred way to turn a list of columns into a data.frame.
Note that it doesn't support recycling; if that's required, use \code{\link[=data.frame]{data.frame()}}.
}
\examples{
# will produce lints
lint(
  text = "do.call(cbind.data.frame, x)",
  linters = list2df_linter()
)

lint(
  text = "do.call('cbind.data.frame', x)",
  linters = list2df_linter()
)

lint(
  text = "do.call(cbind.data.frame, list(a = 1, b = 1:10))",
  linters = list2df_linter()
)

# okay
lint(
  text = "list2df(x)",
  linters = list2df_linter()
)

lint(
  text = "data.frame(list(a = 1, b = 1:10))",
  linters = list2df_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
