% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDABatch.R
\name{LDABatch}
\alias{LDABatch}
\title{LDA Replications on a Batch System}
\usage{
LDABatch(
  docs,
  vocab,
  n = 100,
  seeds,
  id = "LDABatch",
  load = FALSE,
  chunk.size = 1,
  resources,
  ...
)
}
\arguments{
\item{docs}{[\code{list}]\cr
Documents as received from \code{\link[tosca]{LDAprep}}.}

\item{vocab}{[\code{character}]\cr
Vocabularies passed to \code{\link[lda]{lda.collapsed.gibbs.sampler}}.
For additional (and necessary) arguments passed, see ellipsis (three-dot argument).}

\item{n}{[\code{integer(1)}]\cr
Number of Replications.}

\item{seeds}{[\code{integer(n)}]\cr
Random Seeds for each Replication.}

\item{id}{[\code{character(1)}]\cr
Name for the registry's folder.}

\item{load}{[\code{logical(1)}]\cr
If a folder with name \code{id} exists: should the existing registry be loaded?}

\item{chunk.size}{[\code{integer(1)}]\cr
Requested chunk size for each single chunk. See \code{\link[batchtools]{chunk}}.}

\item{resources}{[\code{named list}]\cr
Computational resources for the jobs to submit. See \code{\link[batchtools]{submitJobs}}.}

\item{...}{additional arguments passed to \code{\link[lda]{lda.collapsed.gibbs.sampler}}.
Arguments will be coerced to a vector of length \code{n}.
Default parameters are \code{alpha = eta = 1/K} and \code{num.iterations = 200}.
There is no default for \code{K}.}
}
\value{
[\code{named list}] with entries \code{id} for the registry's folder name,
\code{jobs} for the submitted jobs' ids and its parameter settings and
\code{reg} for the registry itself.
}
\description{
Performs multiple runs of Latent Dirichlet Allocation on a batch system using
the \code{\link[batchtools]{batchtools-package}}.
}
\details{
The function generates multiple LDA runs with the possibility of
using a batch system. The integration is done by the
\code{\link[batchtools]{batchtools-package}}. After all jobs of the
corresponding registry are terminated, the whole registry can be ported to
your local computer for further analysis.

The function returns a \code{LDABatch} object. You can receive results and
all other elements of this object with getter functions (see \code{\link{getJob}}).
}
\examples{
\dontrun{
batch = LDABatch(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 15)
batch
getRegistry(batch)
getJob(batch)
getLDA(batch, 2)

batch2 = LDABatch(docs = reuters_docs, vocab = reuters_vocab, K = 15, chunk.size = 20)
batch2
head(getJob(batch2))
}

}
\seealso{
Other batch functions: 
\code{\link{as.LDABatch}()},
\code{\link{getJob}()},
\code{\link{mergeBatchTopics}()}

Other LDA functions: 
\code{\link{LDA}()},
\code{\link{LDARep}()},
\code{\link{getTopics}()}
}
\concept{LDA functions}
\concept{batch functions}
