% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ItemInfo.R
\name{plot.ItemInfo}
\alias{plot.ItemInfo}
\title{Plot of information functions}
\usage{
\method{plot}{ItemInfo}(
  x,
  which = "ItemInfo",
  outcome = "all",
  legend.loc = "topright",
  legend = NULL,
  add = FALSE,
  shades = TRUE,
  ...
)
}
\arguments{
\item{x}{an object inheriting from classes \code{ItemInfo}}

\item{which}{character specifying the values to plot. Should be one of 'ItemInfo' for
the Fisher information function of the ordinal outcomes, 'LevelInfo' for the
information of each item's level or 'LevelProb' for the probability of the item's
levels.  Default to 'ItemInfo'.}

\item{outcome}{character specifying the outcome to consider. Default to "all".}

\item{legend.loc}{keyword for the position of the legend from the list
\code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"},
\code{"topleft"},\code{"top"}, \code{"topright"}, \code{"right"} and
\code{"center"}.}

\item{legend}{character or expression to appear in the legend. If no legend
should be added, \code{"legend"} should be NULL.}

\item{add}{logical indicating if the curves should be added to an existing
plot. Default to FALSE.}

\item{shades}{logical indicating if confidence intervals should be
represented with shades. Default to FALSE, the confidence intervals are
represented with dotted lines.}

\item{\dots}{other parameters to be passed through to plotting functions or
to legend}
}
\description{
This function plots the information functions stemmed
from a \code{lcmm} or \code{multlcmm} object with ordinal outcomes modeled via threshold links.
}
\author{
Viviane Philipps and Cecile Proust-Lima
}
