% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kfre_metrics-doc.R
\name{plot_kfre_metrics}
\alias{plot_kfre_metrics}
\title{Plot ROC and Precision Recall curves for KFRE variants}
\arguments{
\item{df}{Data frame containing model probabilities and outcomes.}

\item{num_vars}{Integer vector, KFRE model sizes to plot, any of 4, 6, 8.}

\item{fig_size}{Numeric length 2, plot device width and height.}

\item{mode}{Character, "both" to return plots, otherwise draw only.}

\item{image_path_png}{Optional directory to save PNGs.}

\item{image_path_svg}{Optional directory to save SVGs.}

\item{image_prefix}{Optional filename prefix.}

\item{bbox_inches}{Character, passed through when saving.}

\item{plot_type}{Character, which plots to render.}

\item{save_plots}{Logical, save plots to disk if TRUE.}

\item{show_years}{Integer vector, horizons to show, any of 2, 5.}

\item{plot_combinations}{Logical, if TRUE draw pairwise overlays.}

\item{show_subplots}{Logical, arrange subplots when TRUE.}

\item{decimal_places}{Integer digits for annotations.}

\item{open_new_device}{Logical, open device before plotting.}
}
\value{
List of ggplot objects when \code{mode == "both"}, else \code{NULL}.
}
\description{
Draws ROC and PR curves for the selected models and horizons. When
\code{mode} is "both", returns a list of ggplot objects. Otherwise, draws
the plots and returns \code{NULL} invisibly.
}
