% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{diagnose_join}
\alias{diagnose_join}
\title{Diagnose a join before executing}
\usage{
diagnose_join(x, y, by = NULL, use_joinspy = TRUE)
}
\arguments{
\item{x}{Left data frame.}

\item{y}{Right data frame.}

\item{by}{Join specification.}

\item{use_joinspy}{If TRUE (default), use joinspy for enhanced diagnostics
when available. Set to FALSE to use built-in diagnostics only.}
}
\value{
A list with cardinality information, or a JoinReport object if
joinspy is used.
}
\description{
Analyzes join cardinality without performing the full join.
Useful for detecting many-to-many joins that would explode row count.
}
\details{
If the joinspy package is installed, this function delegates to
\code{joinspy::join_spy()} for enhanced diagnostics including whitespace
detection, encoding issues, and detailed match analysis.
}
\examples{
x <- data.frame(id = c(1, 1, 2), a = 1:3)
y <- data.frame(id = c(1, 1, 2), b = 4:6)
diagnose_join(x, y, by = "id", use_joinspy = FALSE)

}
\seealso{
\code{joinspy::join_spy()} for enhanced diagnostics (if installed)
}
