% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/possible_ids.R
\name{filter_vars}
\alias{filter_vars}
\title{Auxiliary function to select vars of data table}
\usage{
filter_vars(
  dt,
  vars = names(dt),
  include = NULL,
  exclude = NULL,
  include_classes = NULL,
  exclude_classes = NULL,
  verbose = TRUE
)
}
\arguments{
\item{dt}{data frame}

\item{vars}{character: A vector of variable names to consider for identifying unique combinations.}

\item{include}{character: Name of variable to be included, that might belong
to the group excluded in the \code{exclude}}

\item{exclude}{character: Names of variables to exclude}

\item{include_classes}{character: classes to include in the analysis (e.g.,
"numeric", "integer", "date")}

\item{exclude_classes}{character: classes to exclude from analysis (e.g.,
"numeric", "integer", "date")}

\item{verbose}{logical: If FALSE no message will be displayed. Default is
TRUE}
}
\value{
character vector of selected vars
}
\description{
Auxiliary function to select vars of data table
}
\keyword{internal}
