% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_coefficient_matrix_create.R
\name{output_coefficient_matrix_create}
\alias{output_coefficient_matrix_create}
\title{Create an output coefficient matrix}
\usage{
output_coefficient_matrix_create(data_table, total = "tfu", digits = NULL)
}
\arguments{
\item{data_table}{A symmetric input–output table, use table, margins, or
tax table retrieved by \code{\link[=iotable_get]{iotable_get()}}. If you request
\code{total = "tfu"} (total final use), you must supply a full table from
\code{\link[=iotable_get]{iotable_get()}} because the TFU column is in the second quadrant.}

\item{total}{Which total to use for normalization. Use \code{"total"} (or the
present table variant name, e.g. \code{"CPA_TOTAL"}) for output by product, or
\code{"tfu"} / \code{"total_final_use"} / \code{"final_demand"} for total final use.
Default: \code{"tfu"}.}

\item{digits}{Integer number of decimal places for rounding. Default \code{NULL}
(no rounding).}
}
\value{
A \code{data.frame} whose first column is the key (product labels) and
the remaining columns form the output-coefficient matrix. Column order
follows the input.
}
\description{
Create an output-coefficient matrix from a symmetric input–output table or
a use table. Output coefficients can be interpreted as the market shares
of products in total output (row-wise normalization).
}
\details{
Let \eqn{Z} be the inter-industry flow block and \eqn{x} the vector of
product output (or, for final-demand shares, total final use).
The output-coefficient matrix \eqn{B} is defined row-wise as
\eqn{b_{ij} = z_{ij} / x_i}. In practice, zeros in the denominator can make
equations unsolvable; this function replaces zeros with a small epsilon
(\code{1e-6}) to avoid division by zero.

Eurostat, \emph{Manual of Supply, Use and Input-Output Tables} (e.g., pp. 495,
507) describes output coefficients and the Ghosh framework you may use
these with.
}
\examples{
data_table <- iotable_get()
output_coefficient_matrix_create(
  data_table = data_table,
  total = "tfu",
  digits = 4
)

}
\seealso{
Other analytic object functions: 
\code{\link{ghosh_inverse_create}()},
\code{\link{input_flow_get}()},
\code{\link{leontief_inverse_create}()},
\code{\link{leontief_matrix_create}()}
}
\concept{analytic object functions}
