% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clint_L0}
\alias{clint_L0}
\title{Clint Level-0 Example Data set}
\format{
A level-0 data.frame with 247 rows and 16 variables: \describe{
\item{\code{Compound}}{Name of the test analyte/compound}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard - CCD)}
\item{\code{Lab.Compound.ID}}{Compound as described in the laboratory}
\item{\code{Date}}{Date the sample was added to the MS analyzer}
\item{\code{Sample}}{Sample description used in the laboratory}
\item{\code{Type}}{Type of Clint sample}
\item{\code{Compound.Conc}}{Expected (or nominal) concentration of analyte (for calibration curve)}
\item{\code{Peak.Area}}{Peak area of analyte (target compound)}
\item{\code{ISTD.Peak.Area}}{Peak area of internal standard (ISTD) compound (pixels)}
\item{\code{ISTD.Name}}{Name of the internal standard (ISTD) analyte/compound}
\item{\code{Analysis.Params}}{Column contains the retention time}
\item{\code{Level0.File}}{Name of the laboratory data file from which the level-0 sample data was extracted}
\item{\code{Level0.Sheet}}{Name of the Excel workbook 'sheet' from which the level-0 sample data was extracted}
\item{\code{Sample.Text}}{Additional notes on the sample}
\item{\code{Time}}{Time when the sample was measured - in hours (h)}
\item{\code{Dilution.Factor}}{Number of times the sample was diluted}
}
}
\usage{
clint_L0
}
\description{
Mass Spectrometry measurements of intrinsic hepatic clearance (Clint) for cryopreserved 
pooled human hepatocytes. Chemicals were per- and poly-fluorinated alkyl substance
(PFAS) samples. The experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. This data set is a subset of 
experimental data containing samples for 3 test analytes/compounds.
}
\references{
\insertRef{shibata2002prediction}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{datasets}
