% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRscan_v2.R
\name{incRscan_v2}
\alias{incRscan_v2}
\title{Scoring of incubation based on a fixed temperature threshold}
\usage{
incRscan_v2(
  data,
  temp.name,
  sensitivity,
  temperature_threshold,
  temp.diff.threshold,
  env.temp
)
}
\arguments{
\item{data}{data frame for analysis. It must contained four columns named as follow:
\code{date}, \code{temp1}, \code{dec_time} and \code{index}, where \code{temp1} is the difference between
the \emph{ith} and  \emph{i-1th} temperature recordings; \code{dec_time} is time in
decimal hours; and \code{index} is a running number from 1 to \emph{N}, \emph{N} being the 
total number of observations. \code{\link{incRprep}} returns a data frame with
these variables and the correct names, ready to be passed through \code{incRscan}.}

\item{temp.name}{(character object) name of the column containing temperature data 
in \code{data}.}

\item{sensitivity}{percentage of reduction in temperature threshold. When nest temperature
does not drop close to environmental temperature, this value can be kept to 1. If 
nest temperature follows environmental temperature at any point, 
then, adjustment of this value may
be required to detect short on/off-bouts at lower nest temperatures (see details).}

\item{temperature_threshold}{Maximum temperature difference between two consecutive nest temperature recordings 
allowed for an on-bout. When the difference in nest temperature between two consecutive recordings is higher than
this value, an off-bout is detected.}

\item{temp.diff.threshold}{threshold for temperature difference between \code{env.temp} and an observation which
triggers application of the sensitivity parameter.}

\item{env.temp}{name of a column containing environmental temperatures.}
}
\value{
The function returns the original data frame with a new column named 'incR_score'. 
This new variable is formed by 1's and 0's,
representing whether the incubating individual is inside ("1") or outside the nest ("0").
#' @section Details:
See \code{\link{incRenv}} for more details
}
\description{
Modified version of \code{incRscan}. Data points are assigned to incubation on/off-bout based on
a fixed temperature threshold for the difference in nest temperature expected when an off-bout starts.
}
\examples{
# incR_procdata is a data frame processed by incRprep and incRenv.
# It contains suitable information to run incRscan
data(incR_procdata)

incubation.analysis <- incRscan_v2 (data=incR_procdata, 
                                  temp.name="temperature",
                                  temperature_threshold = 0.75,
                                  sensitivity=0.15,
                                  temp.diff.threshold=5,
                                  env.temp="env_temp")
}
\seealso{
\code{\link{incRprep}} \code{\link{incRenv}} \code{\link{incRscan}}
}
\author{
Pablo Capilla-Lasheras
}
