% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_npfit.R
\name{interpol_msfit}
\alias{interpol_msfit}
\title{Given a \code{msfit} object, linearly interpolate the cumulative hazard 
taking into account the support sets for \code{msfit} objects.}
\usage{
interpol_msfit(msfit, times)
}
\arguments{
\item{msfit}{A \code{msfit} object.}

\item{times}{Times at which to interpolate the \code{msfit} object.}
}
\value{
An \code{msfit} object containing the interpolated hazards
}
\description{
After using this function, use probtrans to get interpolated 
transition probabilities.
}
\examples{
library(mstate)
tmat <- trans.illdeath()
times <- seq(0, 5, 0.1)
ms_fit <- list(Haz = data.frame(time = rep(times, 3),
                                Haz = c(replicate(3, cumsum(runif(length(times), 0, 0.02)))),
                                trans = rep(1:3, each = length(times))),
               trans = tmat)
class(ms_fit) <- "msfit"

ms_fit_interpolated <- interpol_msfit(ms_fit, seq(0, 5, 0.01))

}
