% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_num}
\alias{filter_num}
\title{Filter data by levels of numeric variables}
\usage{
filter_num(data, var, op = c("<=", "<", ">=", ">", "==", "!="), num)
}
\arguments{
\item{data}{A dataframe or survey design object to be filtered.}

\item{var}{The name of the column in \code{data} to be filtered by.}

\item{op}{A logical operator to apply for the filtering condition.
Valid options are: "<=", "<", ">=", ">", "==", or "!=".}

\item{num}{The numeric value for which the specified \code{op} is applied.}
}
\value{
A filtered dataframe with the tidyverse code attached.
}
\description{
This function filters a dataframe or survey design object by applying a
specified boolean condition to one of its numeric variables. The resulting
filtered dataframe is returned, along with the tidyverse code used to
generate it.
}
\examples{
filtered <- filter_num(iris, var = "Sepal.Length", op = "<=", num = 5)
cat(code(filtered))
head(filtered)

library(survey)
data(api)
svy <- svydesign(~ dnum + snum,
    weights = ~pw, fpc = ~ fpc1 + fpc2,
    data = apiclus2
)
svy_filtered <- filter_num(svy, var = "api00", op = "<", num = 700)
cat(code(svy_filtered))

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin, Tom Elliott, Zhaoming Su
}
