% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_do.R
\name{scale_do}
\alias{scale_do}
\title{Alternative \link[base]{scale} Methods}
\usage{
scale_do(x, center, scale)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}}

\item{center}{\link[base]{function}}

\item{scale}{\link[base]{function}}
}
\value{
The function \code{\link[=scale_do]{scale_do()}} returns a \link[base]{numeric} \link[base]{vector} of the same length as \code{x}.
}
\description{
Alternative \link[base]{scale} using \link[stats]{median}, \link[stats]{IQR} and \link[stats]{mad}.
}
\details{
The function \code{\link[=scale_do]{scale_do()}} performs scaling according to user-specified
definition of \code{center} and \code{scale}.
}
\examples{
set.seed(1315); x = rnorm(20)
x |> scale_do(center = median, scale = mad) 
x |> scale_do(center = median, scale = IQR) 
}
\keyword{internal}
