% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lit_cheminfo.R
\name{get_lit_cheminfo}
\alias{get_lit_cheminfo}
\title{Get literature Chemical Information.}
\usage{
get_lit_cheminfo(info = "CAS", species = "Human")
}
\arguments{
\item{info}{A single character vector (or collection of character vectors)
from
"Compound", "CAS", "MW", "Raw.Experimental.Percentage.Unbound",
"Entered.Experimental.Percentage.Unbound", "Fub", "source_PPB",
"Renal_Clearance", "Met_Stab", "Met_Stab_entered",
"r2", "p.val", "Concentration..uM.", "Css_lower_5th_perc.mg.L.", 
"Css_median_perc.mg.L.", "Css_upper_95th_perc.mg.L.",
"Css_lower_5th_perc.uM.","Css_median_perc.uM.","Css_upper_95th_perc.uM.",
and "Species".}

\item{species}{Species desired (either "Rat" or default "Human").}
}
\value{
\item{info}{Table/vector containing values specified in "info" for
valid chemicals.}
}
\description{
This function provides the information specified in "info=" for all
chemicals with data from the Wetmore et al. (2012) and (2013) publications
and other literature.
}
\examples{

get_lit_cheminfo()
get_lit_cheminfo(info=c('CAS','MW'))

}
\references{
\insertRef{wetmore2012integration}{httk}

\insertRef{wetmore2013relative}{httk}

\insertRef{wetmore2015incorporating}{httk}
}
\author{
John Wambaugh
}
\keyword{Literature}
\keyword{Retrieval}
