\name{switchDetector}
\alias{switchDetector}
\title{Switch Detector}
\description{
Detect switch errors in the haplotypes of a half-sib family.
}
\usage{
switchDetector(groupMatrix)
}
\arguments{
  \item{groupMatrix}{
    \code{matrix}. Group matrix generated by \code{\link{groupMatSingle}}.
  }
}
\value{
A \code{list} of integer vectors. The list length equals the number of individuals.
Each vector contains the locations of detected switch errors for that individual.
}
\seealso{
\code{\link{groupMatSingle}}
}
\examples{
haplotype <- .simulateHalfsib(8, 3000, type = "haplotype")$phased
switches <- list(2500,0,0,1200,c(1000,2000),500,2000,0)

haplotype2 <- addSwitch(haplotype, switches, 0)
gMat <- groupMatSingle(haplotype2, 100, 2, "haplotype")

switchDetector(gMat)
}
\keyword{switch}
\keyword{haplotype}
