% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsphase.R
\name{.fillGap}
\alias{.fillGap}
\title{Fill gaps in a paternal strand vector (native routine wrapper)}
\usage{
.fillGap(paternalStrandBMH)
}
\arguments{
\item{paternalStrandBMH}{An integer (or numeric) vector representing the
paternal strand state (e.g., output from block-building routines). The
vector is coerced to integer before calling native code.}
}
\value{
An integer vector of the same length as \code{paternalStrandBMH}
  containing the gap-filled strand values.
}
\description{
Internal wrapper around the native C routine \code{fillGap}. It fills
zero-valued gaps in a paternal-strand vector by propagating values from
neighbouring non-zero positions (see native implementation for exact rules).
}
\details{
This function calls compiled code via \code{\link[base]{.C}}:
\code{.C("fillGap", ...)}.
}
\seealso{
\code{\link[base]{.C}}
}
\author{
mhf
}
\keyword{internal}
