% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prin_vars}
\alias{prin_vars}
\title{Determine Principle Outputs}
\usage{
prin_vars(data, max_vars = length(data), var_cut = 0.95)
}
\arguments{
\item{data}{The model outputs}

\item{max_vars}{The maximum number of outputs allowed in the output}

\item{var_cut}{The desired proportion of variance explained}
}
\value{
A list \code{list(ordered_variables, cumulative_variance)}
}
\description{
Given model outputs, determine those which are most informative for emulation.
}
\details{
For models with large numbers of outputs, it may not be useful or meaningful
to emulate every output at every wave; particularly at early waves, the main
effects can often be explained by a small number of model outputs. This
function determines those outputs which contribute most highly to the model
variation across the space.

Two cut-off points for informative outputs are available: \code{max_vars}
allows one to limit the number of outputs emulated, while \code{var_cut}
will continue to select outputs until a given proportion of variation has
been explained. By default, no maximum number of variables is imposed and
the desired variation explained is 95% of the total.

The output is a list of two elements: the first, a set of variable names
ordered by variance explained (the first being the most informative); the
second a record of the cumulative variance explained upon inclusion of each
of the outputs.
}
\examples{
# Simple example using SIR data
sir_data <- rbind.data.frame(SIRSample$training, SIRSample$validation)
# Selects nS, nR as informative
prin_vars(sir_data)
# Pick only the first: max_vars overrides var_cut
prin_vars(sir_data, max_vars = 1, var_cut = 1)


}
