/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#if !(defined H5HG_FRIEND || defined H5HG_MODULE)
#error "Do not include this file outside the H5HG package!"
#endif

#ifndef H5HGpkg_H
#define H5HGpkg_H

#include "H5HGprivate.h"

#include "H5ACprivate.h" 
#include "H5FLprivate.h" 

H5FL_EXTERN(H5HG_heap_t);

H5FL_SEQ_EXTERN(H5HG_obj_t);

H5FL_BLK_EXTERN(gheap_chunk);

#define H5HG_VERSION 1

#define H5HG_MINSIZE 4096

#define H5HG_ALIGNMENT    8
#define H5HG_ALIGN(X)     (H5HG_ALIGNMENT * (((X) + H5HG_ALIGNMENT - 1) / H5HG_ALIGNMENT))
#define H5HG_ISALIGNED(X) ((X) == H5HG_ALIGN(X))

#define H5HG_SIZEOF_HDR(f)                                                                                   \
    (size_t) H5HG_ALIGN(4 +                                                                \
                        1 +                                                               \
                        3 +                                                                    \
                        H5F_SIZEOF_SIZE(f)) 

#define H5HG_SIZEOF_OBJHDR(f)                                                                                \
    (size_t) H5HG_ALIGN(2 +                                                             \
                        2 +                                                              \
                        4 +                                                                    \
                        H5F_SIZEOF_SIZE(f)) 

#define H5HG_NOBJS(f, z) ((((z)-H5HG_SIZEOF_HDR(f)) / H5HG_SIZEOF_OBJHDR(f) + 2))

typedef struct H5HG_obj_t {
    int      nrefs; 
    size_t   size;  
    uint8_t *begin; 
} H5HG_obj_t;

struct H5F_shared_t;

struct H5HG_heap_t {
    H5AC_info_t cache_info;      
    haddr_t  addr;               
    size_t   size;               
    uint8_t *chunk;              
    size_t nalloc;               
    size_t nused;                
    struct H5F_shared_t *shared; 
    H5HG_obj_t          *obj;    
};

H5_DLL herr_t       H5HG__free(H5HG_heap_t *heap);
H5_DLL H5HG_heap_t *H5HG__protect(H5F_t *f, haddr_t addr, unsigned flags);

#endif 
