% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance_mcm.R
\name{concordance_mcm}
\alias{concordance_mcm}
\title{C-statistic for mixture cure models}
\usage{
concordance_mcm(object, newdata, cure_cutoff = 5, model_select = "AIC")
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs},
\code{cureem}, \code{cv_curegmifs}, or \code{cv_cureem}.}

\item{newdata}{an optional data.frame that minimally includes the incidence
and/or latency variables to use for predicting the response. If omitted, the
training data are used.}

\item{cure_cutoff}{cutoff value for cure, used to produce a proxy for the
unobserved cure status (default is 5 representing 5 years). Users
should be careful to note the time scale of their data and adjust this
according to the time scale and clinical application.}

\item{model_select}{either a case-sensitive parameter for models fit using
\code{curegmifs} or \code{cureem} or any numeric step along the solution path
can be selected. The default is \code{model_select = "AIC"} which calculates
the predicted values using the coefficients from the model achieving the
minimum AIC. The complete list of options are:
\itemize{
\item \code{"AIC"} for the minimum AIC (default).
\item \code{"mAIC"} for the minimum modified AIC.
\item \code{"cAIC"} for the minimum corrected AIC.
\item \code{"BIC"}, for the minimum BIC.
\item \code{"mBIC"} for the minimum modified BIC.
\item \code{"EBIC"} for the minimum extended BIC.
\item \code{"logLik"} for the step that maximizes the
log-likelihood.
\item \code{model_select = n} where n is any numeric value from the
solution path.
}
This option has no effect for objects fit using \code{cv_curegmifs} or
\code{cv_cureem}.}
}
\value{
value of C-statistic for the cure models.
}
\description{
This function calculates the C-statistic using the cure status weighting
(CSW) method proposed by Asano and Hirakawa (2017).
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
testing <- temp$testing
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
concordance_mcm(fit, model_select = "cAIC")
concordance_mcm(fit, newdata = testing, model_select = "cAIC")
}
\references{
Asano, J. and Hirakawa, H. (2017) Assessing the prediction
accuracy of a cure model for censored survival data with long-term survivors:
Application to breast cancer data. \emph{Journal of Biopharmaceutical
Statistics}, \bold{27}:6, 918--932.
}
\seealso{
\code{\link{auc_mcm}}
}
\keyword{univar}
