% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_collinearity.R
\name{check_collinearity}
\alias{check_collinearity}
\title{Check Collinearity Using VIF for Fitted Models}
\usage{
check_collinearity(model)
}
\arguments{
\item{model}{A fitted model object with class "uni_reg", "multi_reg",
"uni_reg_nbin", or "multi_reg_nbin".}
}
\value{
A tibble containing VIF values and interpretation.
For multivariable models, returns one tibble.
For univariate models, an error is raised indicating VIF is not applicable.
}
\description{
Computes Variance Inflation Factors (VIF) for fitted models returned by
uni_reg(), multi_reg(), uni_reg_nbin(), or multi_reg_nbin().
Returns one VIF table per model. For multivariate models only
}
\examples{
if (requireNamespace("gtregression", quietly = TRUE) &&
  requireNamespace("mlbench", quietly = TRUE) &&
  getRversion() >= "4.1.0") {
  data(PimaIndiansDiabetes2, package = "mlbench")
  pima <- PimaIndiansDiabetes2 |> dplyr::filter(!is.na(diabetes))
  pima$diabetes <- ifelse(pima$diabetes == "pos", 1, 0)
  fit <- multi_reg(pima,
    outcome = "diabetes",
    exposures = c("age", "mass", "glucose"),
    approach = "logit"
  )
  check_collinearity(fit)
}
}
