% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goose_essentials.R
\name{goose_continuation_prompt}
\alias{goose_continuation_prompt}
\title{Generate Continuation Prompt for Next Session}
\usage{
goose_continuation_prompt(
  path = ".",
  include_files = TRUE,
  include_todos = TRUE,
  save_to = NULL
)
}
\arguments{
\item{path}{Path to review (default: current working directory)}

\item{include_files}{Whether to include file listing (default: TRUE)}

\item{include_todos}{Whether to scan for TODO comments (default: TRUE)}

\item{save_to}{Path to save the continuation prompt (auto-generated if NULL)}
}
\value{
Path to the saved continuation prompt
}
\description{
Reviews current work and generates a comprehensive continuation prompt
with progress tracking, file mapping, and next steps for seamless handoff
to the next working session.
}
\examples{
\dontrun{
# Generate continuation prompt for current project
goose_continuation_prompt()

# Generate without file listing
goose_continuation_prompt(include_files = FALSE)

# Save to specific location
goose_continuation_prompt(save_to = "project_docs/continuation.md")
}

}
