% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{should_skip_token_checks}
\alias{should_skip_token_checks}
\title{Determines whether token presence and validity checks should be skipped.}
\usage{
should_skip_token_checks()
}
\value{
boolean
}
\description{
Skipping checks is useful in certain special cases, such as testing. Tests
might rely on mocked API responses or fake API implementations, which don't
require a valid token. It wouldn't make sense to demand a valid token in that
context.
}
\details{
\code{googleAuthR} uses this function to know when the execution context is
such that token checks should be skipped. This is ultimately determined by
the value of the \code{googleAuthR.skip_token_checks} boolean option. Users
or consumer libraries can set this option to signal that authentication is
not needed.

In addition, this function detects the use of \code{httptest::with_mock_API}
and skips token checks in that case as well.
}
\seealso{
Other authentication functions: 
\code{\link{gar_attach_auto_auth}()},
\code{\link{gar_auth}()},
\code{\link{gar_auth_service}()},
\code{\link{gar_auto_auth}()},
\code{\link{gar_gce_auth}()},
\code{\link{get_google_token}()},
\code{\link{token_exists}()}
}
\concept{authentication functions}
\keyword{internal}
