% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calc_texture}
\alias{calc_texture}
\title{Calculates a glcm texture for use in the glcm.R script}
\usage{
calc_texture(d, n_grey, window_dims, shift, statistics, na_opt, na_val)
}
\arguments{
\item{d}{a matrix containing the pixels to be used in the texture
calculation}

\item{n_grey}{number of grey levels to use in texture calculation}

\item{window_dims}{2 element list with row and column dimensions of the
texture window}

\item{shift}{a matrix where each row gives an (x, y) shift to use when 
computing co-occurrency matrices. Textures will be calculated for each 
shift, and the average over all shifts will be returned.}

\item{statistics}{a list of strings naming the texture statistics to 
calculate}

\item{na_opt}{one of "ignore", "center", or "any"}

\item{na_val}{what value to use to fill missing values on edges or where
necessary due to chosen na_opt value}
}
\value{
a list of length equal to the length of the \code{statistics} input 
parameter, containing the selected textures measures
}
\description{
This function is called by the \code{\link{glcm}} function. It is 
not intended to be used directly.
}
\examples{
# Calculate GLCM textures on a matrix using low-level calc_texture function
d <- matrix(seq(1:25), nrow=5, ncol=5, byrow=TRUE)
calc_texture(d, n_grey=25, window_dims=c(3,3),
             shift=matrix(c(1,1), nrow=1), statistics=c('variance'),
             na_opt="any", na_val=NA)
}
