% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{zoom}
\alias{zoom}
\alias{crop_to}
\alias{view_box}
\title{Zoom in to a subset of a plot}
\usage{
crop_to(subset, data, ...)

view_box(subset, data)
}
\arguments{
\item{subset}{An indexing expression to select rows from \code{data}.
Tidy-evaluted in the context of \code{data}.}

\item{data}{An \code{sf} data frame.}

\item{...}{Additional arguments passed to \code{coord_sf()}.}
}
\value{
\code{crop_to()} returns a \code{coord_sf()} object to be added to a ggplot.
\code{view_box()} returns a \code{geom_rect()} layer to be added to a ggplot.
}
\description{
Provides \code{crop_to()} to zoom in to a subset of a data frame, and \code{view_box()}
to annotate the zoomed-in region on the full plot.
}
\examples{
library(ggplot2)
data(oregon)

ggplot(oregon, aes(fill = ndv / (ndv + nrv))) +
    geom_sf(size = 0) +
    scale_fill_538(name = "") +
    view_box(county == "Multnomah", oregon) +
    theme_map()

ggplot(oregon, aes(fill = ndv / (ndv + nrv))) +
    geom_sf(size = 0) +
    scale_fill_538(name = "") +
    crop_to(county == "Multnomah", oregon) +
    theme_map()
}
