% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-.R, R/stat-align.R, R/stat-bin.R,
%   R/stat-summary-2d.R, R/stat-bin2d.R, R/stat-bindot.R, R/stat-binhex.R,
%   R/stat-boxplot.R, R/stat-connect.R, R/stat-contour.R, R/stat-count.R,
%   R/stat-density-2d.R, R/stat-density.R, R/stat-ecdf.R, R/stat-ellipse.R,
%   R/stat-function.R, R/stat-identity.R, R/stat-manual.R, R/stat-qq-line.R,
%   R/stat-qq.R, R/stat-quantilemethods.R, R/stat-smooth.R, R/stat-sum.R,
%   R/stat-summary-bin.R, R/stat-summary-hex.R, R/stat-summary.R,
%   R/stat-unique.R, R/stat-ydensity.R
\docType{data}
\name{Stat}
\alias{Stat}
\alias{StatAlign}
\alias{StatBin}
\alias{StatSummary2d}
\alias{StatBin2d}
\alias{StatBindot}
\alias{StatBinhex}
\alias{StatBoxplot}
\alias{StatConnect}
\alias{StatContour}
\alias{StatContourFilled}
\alias{StatCount}
\alias{StatDensity2d}
\alias{StatDensity2dFilled}
\alias{StatDensity}
\alias{StatEcdf}
\alias{StatEllipse}
\alias{StatFunction}
\alias{StatIdentity}
\alias{StatManual}
\alias{StatQqLine}
\alias{StatQq}
\alias{StatQuantile}
\alias{StatSmooth}
\alias{StatSum}
\alias{StatSummaryBin}
\alias{StatSummaryHex}
\alias{StatSummary}
\alias{StatUnique}
\alias{StatYdensity}
\title{Stats}
\description{
All \verb{stat_*()} functions (like \code{stat_bin()}) return a layer that
contains a \verb{Stat*} object (like \code{StatBin}). The \verb{Stat*}
object is responsible for rendering the data in the plot.
}
\details{
Each of the \verb{Stat*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended
from the top-level \code{Stat}, and each implements various methods and
fields. The object and its parameters are chaperoned by the \link{Layer} class.

To create a new type of Stat object, you typically will want to
override one or more of the following:
\itemize{
\item The \code{required_aes} and \code{default_aes} fields.
\item One of the \code{compute_layer()}, \code{compute_panel()} or \code{compute_group()}
functions. Typically it best to implement \code{compute_group()} and use the
higher-up methods when there are substantial performance improvements to
be gained.
\item The \code{finish_layer()} method
}
}
\section{Fields}{

\describe{
\item{\code{required_aes}}{A character vector naming aesthetics that are necessary
to compute the stat.}

\item{\code{non_missing_aes}}{A character vector naming aesthetics that will cause
removal if they have missing values.}

\item{\code{optional_aes}}{A character vector naming aesthetics that will be
accepted by \code{layer()}, but are not required or dscribed in the \code{default_aes}
field.}

\item{\code{default_aes}}{A \link[=aes]{mapping} of default values for aesthetics.
Aesthetics can be set to \code{NULL} to be included as optional aesthetic.}

\item{\code{dropped_aes}}{A character vector naming aesthetics that can be dropped
from the data without warning. Typically used for aesthetics that are
'consumed' during computation like \code{"weight"}.}

\item{\code{extra_params}}{A character vector of parameter names in addition to
those imputed from the \code{compute_panel()} or \code{compute_groups()} methods.
This field can be set to include parameters for \code{setup_data()} methods.
By default, this only contains \code{"na.rm"}.}

\item{\code{retransform}}{A scalar boolean: should the values produced by the
statistic also be transformed in the second pass when recently added
statistics are trained to the scales}

\item{\code{setup_params}}{\strong{Description}

A function method for modifying or checking the parameters based on the
data. The default method returns the parameters unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$setup_params(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list of current parameters}
}

\strong{Value}

A list of parameters}

\item{\code{setup_data}}{\strong{Description}

A function method for modifying or checking the data. The default method
returns data unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$setup_data(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method}
}

\strong{Value}

A data frame with layer data}

\item{\code{compute_layer}}{\strong{Description}

A function method for orchestrating the computation of the statistic. The
default method splits the data and passes on computation tasks to the
panel-level \code{compute_panel()} method. In addition, the default method
handles missing values by removing rows that have missing values for the
aesthetics listed in the \code{required_aes} and \code{non_missing_aes} fields. It is
not recommended to use this method as an extension point.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$compute_layer(data, params, layout)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list of parameters}
\item{\code{layout}}{A pre-trained \verb{<Layout>} ggproto object.}
}

\strong{Value}

A data frame with computed data}

\item{\code{compute_panel,compute_group}}{\strong{Description}

A function method orchestrating the computation of statistics for a single
panel or group. The default \code{compute_panel()} method splits the data into
groups, and passes on computation tasks to the \code{compute_group()} method.
In addition, \code{compute_panel()} is tasked with preserving aesthetics that
are constant within a group and preserving these if the computation loses
them. The default \code{compute_group()} is not implemented.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$compute_panel(data, scales, ...)
Stat$compute_group(data, scales, ...)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{scales}}{A list of pre-trained \code{x} and \code{y} scales. Note that the
position scales are not finalised at this point and reflect the initial
data range before computing stats.}
\item{\code{...}}{Reserved for extensions. By default, this passes parameters
to the \code{compute_group()} method.}
}

\strong{Value}

A data frame with layer data}

\item{\code{finish_layer}}{\strong{Description}

A function method acting as a hook to modify data after scales have been
applied, but before geoms have to render. The default is to pass the data
unaltered. This can be used as an extension point when actual aesthetic
values rather than values mapped to the aesthetic are needed.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$finish_layer(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with layer data}
\item{\code{params}}{A list of parameters}
}

\strong{Value}

A data frame with layer data}

\item{\code{parameters}}{\strong{Description}

A function method for listing out all acceptable parameters for this stat.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$parameters(extra)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{extra}}{A boolean: whether to include the \code{extra_params} field.}
}

\strong{Value}

A character vector of parameter names.}

\item{\code{aesthetics}}{\strong{Description}

A function method for listing out all acceptable aesthetics for this stat.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Stat$aesthetics()
}\if{html}{\out{</div>}}

\strong{Value}

A character vector of aesthetic names.}
}}

\section{Conventions}{


The object name that a new class is assigned to is typically the same as the
class name. Stat class names are in UpperCamelCase and start with the \verb{Stat*}
prefix, like \code{StatNew}.

A constructor function is usually paired wih a Stat class. The constructor
wraps a call to \code{layer()}, where e.g. \code{layer(stat = StatNew)}. The
constructor function name is formatted by taking the Stat class name and
formatting it with snake_case, so that \code{StatNew} becomes \code{stat_new()}.
}

\examples{
# Extending the class
StatKmeans <- ggproto(
  "StatKmeans", Stat,
  # Fields
  required_aes = c("x", "y"),
  # You can relate computed variables to aesthetics using `after_stat()`
  # in defaults
  default_aes = aes(colour = after_stat(cluster)),
  # Methods
  compute_panel = function(data, scales, k = 2L) {
    km <- kmeans(cbind(scale(data$x), scale(data$y)), centers = k)
    data$cluster <- factor(km$cluster)
    data
  }
)

# Building a constructor
stat_kmeans <- function(mapping = NULL, data = NULL, geom = "point",
                        position = "identity", ..., k = 2L, na.rm = FALSE,
                        show.legend = NA, inherit.aes = TRUE) {
  layer(
    mapping = mapping, data = data,
    geom = geom, stat = StatKmeans, position = position,
    show.legend = show.legend, inherit.aes = inherit.aes,
    params = list(na.rm = na.rm, k = k, ...)
  )
}

# Use new stat in plot
ggplot(mpg, aes(displ, hwy)) +
  stat_kmeans(k = 3)
}
\seealso{
The \href{https://ggplot2-book.org/extensions#sec-new-stats}{new stats section} of the online ggplot2 book..

Run \code{vignette("extending-ggplot2")}, in particular the "Creating a
new stat" section.

Other Layer components: 
\code{\link{Geom}},
\code{\link{Layer-class}},
\code{\link{Position}}
}
\concept{Layer components}
\keyword{datasets}
\keyword{internal}
