% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R, R/theme-elements.R
\name{margin}
\alias{margin}
\alias{margin_part}
\alias{margin_auto}
\alias{element}
\alias{element_blank}
\alias{element_rect}
\alias{element_line}
\alias{element_text}
\alias{element_polygon}
\alias{element_point}
\alias{element_geom}
\alias{rel}
\title{Theme elements}
\usage{
margin(t = 0, r = 0, b = 0, l = 0, unit = "pt", ...)

margin_part(t = NA, r = NA, b = NA, l = NA, unit = "pt")

margin_auto(t = 0, r = t, b = t, l = r, unit = "pt")

element()

element_blank()

element_rect(
  fill = NULL,
  colour = NULL,
  linewidth = NULL,
  linetype = NULL,
  color = NULL,
  linejoin = NULL,
  inherit.blank = FALSE,
  size = deprecated(),
  ...
)

element_line(
  colour = NULL,
  linewidth = NULL,
  linetype = NULL,
  lineend = NULL,
  color = NULL,
  linejoin = NULL,
  arrow = NULL,
  arrow.fill = NULL,
  inherit.blank = FALSE,
  size = deprecated(),
  ...
)

element_text(
  family = NULL,
  face = NULL,
  colour = NULL,
  size = NULL,
  hjust = NULL,
  vjust = NULL,
  angle = NULL,
  lineheight = NULL,
  color = NULL,
  margin = NULL,
  debug = NULL,
  inherit.blank = FALSE,
  ...
)

element_polygon(
  fill = NULL,
  colour = NULL,
  linewidth = NULL,
  linetype = NULL,
  color = NULL,
  linejoin = NULL,
  inherit.blank = FALSE,
  ...
)

element_point(
  colour = NULL,
  shape = NULL,
  size = NULL,
  fill = NULL,
  stroke = NULL,
  color = NULL,
  inherit.blank = FALSE,
  ...
)

element_geom(
  ink = NULL,
  paper = NULL,
  accent = NULL,
  linewidth = NULL,
  borderwidth = NULL,
  linetype = NULL,
  bordertype = NULL,
  family = NULL,
  fontsize = NULL,
  pointsize = NULL,
  pointshape = NULL,
  colour = NULL,
  color = NULL,
  fill = NULL,
  ...
)

rel(x)
}
\arguments{
\item{t, r, b, l}{Dimensions of each margin. (To remember order, think trouble).}

\item{unit}{Default units of dimensions. Defaults to "pt" so it
can be most easily scaled with the text.}

\item{...}{Reserved for future expansion.}

\item{fill}{Fill colour. \code{fill_alpha()} can be used to set the transparency
of the fill.}

\item{colour, color}{Line/border colour. Color is an alias for colour.
\code{alpha()} can be used to set the transparency of the colour.}

\item{linewidth, borderwidth, stroke}{Line/border size in mm.}

\item{linetype, bordertype}{Line type for lines and borders respectively. An
integer (0:8), a name (blank, solid, dashed, dotted, dotdash, longdash,
twodash), or a string with an even number (up to eight) of hexadecimal
digits which give the lengths in consecutive positions in the string.}

\item{linejoin}{Line join style, one of \code{"round"}, \code{"mitre"} or \code{"bevel"}.}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}

\item{size, fontsize, pointsize}{text size in pts, point size in mm.}

\item{lineend}{Line end style, one of \code{"round"}, \code{"butt"} or \code{"square"}.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}}

\item{arrow.fill}{Fill colour for arrows.}

\item{family}{The typeface to use. The validity of this value will depend on
the graphics device being used for rendering the plot. See
\href{https://systemfonts.r-lib.org/articles/systemfonts.html}{the systemfonts vignette}
for guidance on the best way to access fonts installed on your computer.
The values \code{"sans"}, \code{"serif"}, and \code{"mono"} should always be valid and
will select the default typeface for the respective styles. However, what
is considered default is dependant on the graphics device and the operating
system.}

\item{face}{Font face ("plain", "italic", "bold", "bold.italic")}

\item{hjust}{Horizontal justification (in \eqn{[0, 1]})}

\item{vjust}{Vertical justification (in \eqn{[0, 1]})}

\item{angle}{Angle (in \eqn{[0, 360]})}

\item{lineheight}{Line height}

\item{margin}{Margins around the text. See \code{\link[=margin]{margin()}} for more
details. When creating a theme, the margins should be placed on the
side of the text facing towards the center of the plot.}

\item{debug}{If \code{TRUE}, aids visual debugging by drawing a solid
rectangle behind the complete text area, and a point where each label
is anchored.}

\item{shape, pointshape}{Shape for points (1-25).}

\item{ink}{Foreground colour.}

\item{paper}{Background colour.}

\item{accent}{Accent colour.}

\item{x}{A single number specifying size relative to parent element.}
}
\value{
An object of class \code{element}, \code{rel}, or \code{margin}.
}
\description{
In conjunction with the \link{theme} system, the \code{element_} functions
specify the display of how non-data components of the plot are drawn.
\itemize{
\item \code{element_blank()}: draws nothing, and assigns no space.
\item \code{element_rect()}: borders and backgrounds.
\item \code{element_line()}: lines.
\item \code{element_text()}: text.
\item \code{element_polygon()}: polygons.
\item \code{element_point()}: points.
\item \code{element_geom()}: defaults for drawing layers.
}

\code{rel()} is used to specify sizes relative to the parent,
\code{margin()}, \code{margin_part()} and \code{margin_auto()} are all used to specify the
margins of elements.
}
\details{
The \code{element_polygon()} and \code{element_point()} functions are not rendered
in standard plots and just serve as extension points.
}
\examples{
# A standard plot
plot <- ggplot(mpg, aes(displ, hwy)) + geom_point()

# Turning off theme elements by setting them to blank
plot + theme(
  panel.background = element_blank(),
  axis.text = element_blank()
)

# Text adjustments
plot + theme(
  axis.text = element_text(colour = "red", size = rel(1.5))
)

# Turning on the axis line with an arrow
plot + theme(
  axis.line = element_line(arrow = arrow())
)

plot + theme(
  panel.background = element_rect(fill = "white"),
  plot.margin = margin_auto(2, unit = "cm"),
  plot.background = element_rect(
    fill = "grey90",
    colour = "black",
    linewidth = 1
  )
)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  geom_smooth(formula = y ~ x, method = "lm") +
  theme(geom = element_geom(
    ink = "red", accent = "black",
    pointsize = 1, linewidth = 2
  ))
}
