% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_bootstrap.R
\name{gas_bootstrap}
\alias{gas_bootstrap}
\title{Bootstrap GAS Model}
\usage{
gas_bootstrap(
  gas_object = NULL,
  method = "parametric",
  rep_boot = 1000L,
  block_length = NULL,
  quant = c(0.025, 0.975),
  y = NULL,
  x = NULL,
  distr = NULL,
  param = NULL,
  scaling = "unit",
  regress = "joint",
  p = 1L,
  q = 1L,
  par_static = NULL,
  par_link = NULL,
  par_init = NULL,
  lik_skip = 0L,
  coef_fix_value = NULL,
  coef_fix_other = NULL,
  coef_fix_special = NULL,
  coef_bound_lower = NULL,
  coef_bound_upper = NULL,
  coef_est = NULL,
  optim_function = wrapper_optim_nloptr,
  optim_arguments = list(opts = list(algorithm = "NLOPT_LN_NELDERMEAD", xtol_rel = 0,
    maxeval = 10000)),
  parallel_function = NULL,
  parallel_arguments = list()
)
}
\arguments{
\item{gas_object}{An optional GAS estimate, i.e. a list of S3 class \code{gas} returned by function \code{\link[gasmodel:gas]{gas()}}.}

\item{method}{A method used for bootstrapping. Supported methods are \code{"parametric"}, \code{"simple_block"}, \code{"moving_block"}, and \code{"stationary_block"}.}

\item{rep_boot}{A number of bootstrapping repetitions.}

\item{block_length}{A length of blocks for methods \code{"simple_block"} and \code{"moving_block"}. A mean length of blocks for method \code{"stationary_block"}.}

\item{quant}{A numeric vector of probabilities determining quantiles.}

\item{y, x, distr, param, scaling, regress, p, q, par_static, par_link, par_init, lik_skip, coef_fix_value, coef_fix_other, coef_fix_special, coef_bound_lower, coef_bound_upper, coef_est}{When \code{gas_object} is not supplied, the estimated model can be specified using these individual arguments. See the arguments and value of the \code{\link[gasmodel:gas]{gas()}} function for more details.}

\item{optim_function}{An optimization function. For suitable wrappers of common R optimization functions, see \code{\link[gasmodel:wrappers_optim]{wrappers_optim}}.}

\item{optim_arguments}{An optional list of arguments to be passed to the optimization function.}

\item{parallel_function}{A parallelization function. For suitable wrappers of common R parallelization functions, see \code{\link[gasmodel:wrappers_parallel]{wrappers_parallel}}. Can be set to \code{NULL} if no parallelization is to be used.}

\item{parallel_arguments}{An optional list of arguments to be passed to the optimization function.}
}
\value{
A \code{list} of S3 class \code{gas_bootstrap} with components:
\item{data$y}{The time series.}
\item{data$x}{The exogenous variables.}
\item{model$distr}{The conditional distribution.}
\item{model$param}{The parametrization of the conditional distribution.}
\item{model$scaling}{The scaling function.}
\item{model$regress}{The specification of the regression and dynamic equation.}
\item{model$t}{The length of the time series.}
\item{model$n}{The dimension of the model.}
\item{model$m}{The number of exogenous variables.}
\item{model$p}{The score order.}
\item{model$q}{The autoregressive order.}
\item{model$par_static}{The static parameters.}
\item{model$par_link}{The parameters with the logarithmic/logistic links.}
\item{model$par_init}{The initial values of the time-varying parameters.}
\item{model$lik_skip}{The number of skipped observations at the beginning of the time series or after \code{NA} values in the likelihood computation.}
\item{model$coef_fix_value}{The values to which coefficients are fixed.}
\item{model$coef_fix_other}{The multiples of the estimated coefficients, which are added to the fixed coefficients.}
\item{model$coef_fix_special}{The predefined structures of \code{coef_fix_value} and \code{coef_fix_other}.}
\item{model$coef_bound_lower}{The lower bounds on coefficients.}
\item{model$coef_bound_upper}{The upper bounds on coefficients.}
\item{model$coef_est}{The estimated coefficients.}
\item{bootstrap$method}{The method used for bootstrapping.}
\item{bootstrap$coef_set}{The bootstrapped sets of coefficients.}
\item{bootstrap$coef_mean}{The mean of bootstrapped coefficients.}
\item{bootstrap$coef_vcov}{The variance-covariance matrix of bootstrapped coefficients.}
\item{bootstrap$coef_sd}{The standard deviation of bootstrapped coefficients.}
\item{bootstrap$coef_pval}{The p-value of bootstrapped coefficients.}
\item{bootstrap$coef_quant}{The quantiles of bootstrapped coefficients.}
}
\description{
A function for bootstrapping coefficients of generalized autoregressive score (GAS) models of Creal et al. (2013) and Harvey (2013).
Method \code{"parametric"} repeatedly simulates time series using the parametric model and re-estimates coefficients.
Methods \code{"simple_block"}, \code{"moving_block"}, and \code{"stationary_block"} perform the standard variations of the circular block bootstrap.
Instead of supplying arguments about the model, the function can be applied to the \code{gas} object obtained by the \code{\link[gasmodel:gas]{gas()}} function.
The function enables parallelization.
}
\note{
Supported generic functions for S3 class \code{gas_bootstrap} include \code{\link[base:summary]{summary()}}, \code{\link[base:plot]{plot()}}, \code{\link[stats:coef]{coef()}}, and \code{\link[stats:vcov]{vcov()}}.
}
\examples{
\donttest{# Load the Daily Toilet Paper Sales dataset
data("toilet_paper_sales")
y <- toilet_paper_sales$quantity
x <- as.matrix(toilet_paper_sales[3:9])

# Estimate GAS model based on the negative binomial distribution
est_negbin <- gas(y = y, x = x, distr = "negbin", regress = "sep")
est_negbin

# Bootstrap the model (can be time-consuming for a larger number of samples)
boot_negbin <- gas_bootstrap(est_negbin, rep_boot = 10)
boot_negbin

# Plot boxplot of bootstrapped coefficients
plot(boot_negbin)}

}
\references{
Creal, D., Koopman, S. J., and Lucas, A. (2013). Generalized Autoregressive Score Models with Applications. \emph{Journal of Applied Econometrics}, \strong{28}(5), 777–795. \doi{10.1002/jae.1279}.

Harvey, A. C. (2013). \emph{Dynamic Models for Volatility and Heavy Tails: With Applications to Financial and Economic Time Series}. Cambridge University Press. \doi{10.1017/cbo9781139540933}.
}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
\code{\link[gasmodel:wrappers_parallel]{wrappers_parallel}}
}
