% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_atlas_agg.R
\name{regions.to.ignore}
\alias{regions.to.ignore}
\title{Give suggestions for regions to ignore for an atlas.}
\usage{
regions.to.ignore(atlas)
}
\arguments{
\item{atlas, }{string. The name of an atlas. Supported strings are 'aparc' and 'aparc.a2009s'.}
}
\value{
vector of strings, the region names.
}
\description{
Give suggestions for regions to ignore for an atlas. These are regions for which many subjects do not have any vertices in them, or the Medial Wall and Unknown regions.
}
\examples{
   aparc_regions_ign = regions.to.ignore('aparc');
   aparc_a2009s_regions_ign = regions.to.ignore('aparc.a2009s');

}
\seealso{
Other atlas functions: 
\code{\link{get.atlas.region.names}()},
\code{\link{group.agg.atlas.native}()},
\code{\link{group.agg.atlas.standard}()},
\code{\link{group.annot}()},
\code{\link{group.label.from.annot}()},
\code{\link{label.from.annotdata}()},
\code{\link{label.to.annot}()},
\code{\link{spread.values.over.annot}()},
\code{\link{spread.values.over.hemi}()},
\code{\link{spread.values.over.subject}()},
\code{\link{subject.annot}()},
\code{\link{subject.atlas.agg}()},
\code{\link{subject.label.from.annot}()},
\code{\link{subject.lobes}()}
}
\concept{atlas functions}
